//
//  $Id: WXKProbeAppDelegate.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKProbeAppDelegate.h"
#import "WXKPhone.h"
#import "WXKPasswordWindowController.h"
#import "WXKProgressWindowController.h"


@implementation WXKProbeAppDelegate

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
	return YES;
}

- (IBAction)sendAllItems:(id)sender
{
	NSRunAlertPanel(@"Not implemented", @"Sending files is not implemented", @"OK", nil, nil);
}

//	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
//	[openPanel setCanChooseFiles:YES];
//	[openPanel setCanChooseDirectories:NO];
//	[openPanel setAllowsMultipleSelection:YES];
//	[openPanel setCanCreateDirectories:NO];
//	[openPanel setPrompt:NSLocalizedStringFromTable(@"Send", @"TestToolsLocalizable", nil)];
//	[openPanel setTitle:NSLocalizedStringFromTable(@"Send", @"TestToolsLocalizable", nil)];
//	[openPanel setMessage:NSLocalizedStringFromTable(@"Select items which you want to send to Kyopon.", @"TestToolsLocalizable", nil)];
//	
//	int result = [openPanel runModalForTypes:nil];
//	if (result == NSOKButton) {
//		NSArray        *URLs       = [openPanel URLs];
//		NSEnumerator   *enumerator = [URLs objectEnumerator];
//		NSURL          *URL;
//		
//		NSMutableArray *dataArray  = [NSMutableArray arrayWithCapacity:[URLs count]];
//		
//		while (URL = [enumerator nextObject]) {
//			NSData *data = [NSData dataWithContentsOfURL:URL];
//			if (data) {
//				if ([removeHeaderBytesBeforeSendingButton state] == NSOnState) {
//					[dataArray addObject:[data subdataWithRange:NSMakeRange(12, [data length] - 12)]];
//				} else {
//					[dataArray addObject:data];
//				}
//			}
//		}
//		WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
//		WXKProgressWindowController *progress = [[[WXKProgressWindowController alloc] initWithParentWindow:nil] autorelease];
//		NSError *error;
//		
//		if ([phone writeAllItemsOfDataType:[dataTypeTextField intValue]
//								 dataArray:dataArray
//							  withPassword:[passwordTextField stringValue]
//								  progress:progress
//									 error:&error] == NO) {
//			[NSApp presentError:error];
//		}
//	}
//}
//

- (IBAction)receiveAllItems:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setCanChooseFiles:NO];
	[openPanel setCanChooseDirectories:YES];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setCanCreateDirectories:YES];
	[openPanel setPrompt:NSLocalizedStringFromTable(@"Receive", @"ProbeLocalizable", nil)];
	[openPanel setTitle:NSLocalizedStringFromTable(@"Receive", @"ProbeLocalizable", nil)];
	[openPanel setMessage:NSLocalizedStringFromTable(@"Select a folder in which items received from Kyopon will be saved.", @"ProbeLocalizable", nil)];
	
	int result = [openPanel runModalForTypes:nil];
	if (result != NSOKButton) return;
	
	NSString *password = [[WXKPasswordWindowController sharedWindowController] password];
	WXKProgressWindowController *progress = [WXKProgressWindowController sharedWindowController];
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	WXKPhoneDataType dataType = [dataTypePopUpButton selectedTag];
	NSArray *dataArray;
	NSError *error;
	
	[progress beginProgressWithMessage:nil];
	
	if ([phone openConnectionWithPassword:password progress:progress error:&error] &&
		(dataArray = [phone arrayOfDataType:dataType error:&error]) != nil)
	{
		[phone closeConnection];
		
		NSURL *folderURL = [openPanel URL];
		NSData *data;
		
		[progress setIndeterminate:YES];
		[progress setMessage:NSLocalizedStringFromTable(@"Writiing received data on your computer...", @"ProbeLocalizable", nil)];
		int i;
		for (i = 0; i < [dataArray count]; i++)
		{
			data = [dataArray objectAtIndex:i];
			
			NSString *filename = [NSString stringWithFormat:@"%d_%03d.txt",
				dataType,
				i];
			NSURL *fileURL = [NSURL URLWithString:filename relativeToURL:folderURL];
//			[data writeToURL:fileURL atomically:YES]; 
			[[data subdataWithRange:NSMakeRange(12, [data length] - 12)] writeToURL:fileURL atomically:YES]; 
			
		}
		[progress endProgress];
	}
	else
	{
		[progress endProgress];
		[NSApp presentError:error modalForWindow:window delegate:nil didPresentSelector:NULL contextInfo:NULL];
	}
}

- (IBAction)fetchList:(id)sender
{
	NSString *password = [[WXKPasswordWindowController sharedWindowController] password];
	WXKProgressWindowController *progress = [WXKProgressWindowController sharedWindowController];
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	WXKPhoneDataType dataType = [dataTypePopUpButton selectedTag];
	NSArray *dataArray;
	NSError *error;
	
	[progress beginProgressWithMessage:nil];
	
	if ([phone openConnectionWithPassword:password progress:progress error:&error] &&
		(dataArray = [phone listOfDataType:dataType error:&error]) != nil)
	{
		[phone closeConnection];
		
		NSEnumerator *enumerator = [dataArray objectEnumerator];
		NSData *data;
		int i = 0;
		while (data = [enumerator nextObject])
		{
			NSString *filename = [NSHomeDirectory() stringByAppendingPathComponent:[NSString stringWithFormat:@"%d.txt", i++]];
			[[data subdataWithRange:NSMakeRange(12, [data length] - 12)] writeToFile:filename atomically:YES];
		}
		[progress endProgress];
	}
	else
	{
		[progress endProgress];
		[NSApp presentError:error];
		return ;
	}
	
}

@end
